<?php

/*
 * Plugin Name: NDI - D-SchemaGen (SCHEMA Generator)
 * Plugin URI: https://nobledynastyinfo.com/
 * Description: <strong><em>**SCHEMA INJECTOR PLUGIN**</em></strong> Unlock the power of structured data with our Schema Generator Plugin at Noble Dynasty Info. Our cutting-edge plugin is designed to streamline the process of implementing schema markup on your website, enhancing its visibility and relevance in search engine results.</p>
 * Version: 1.024
 * Author: Pushparaj Kevin
 * Author URI: https://facebook.com/puspharajkevin
 * Contributor: Noble Dynasty Info
 * Contributor URI: https://nobledynastyinfo.com
 * License: GPL2
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: Noble Dynasty Info
 * Domain Path: /languages
 * Network: true
 * Requires PHP: 7.0
 * Requires at least: 5.0
 * Tested up to: 6.0
 * Requires at least WordPress: 5.0
 * WP-CLI: true
 * GitHub Plugin URI: http://github.com/username/repository
 * GitHub Branch: master
 * Help Us: If you encounter any issues or need support, please visit our [support page](https://nobledynastyinfo.com/support/plugin/).
 */



// Add admin menu
add_action('admin_menu', 'ndi_schema_menu');

function ndi_schema_menu() {
    add_menu_page('D-SchemaGen', 'D-SchemaGen', 'manage_options', 'ndi-schema', 'ndi_schema_page', plugin_dir_url(__FILE__) .'icons/ndi-seo-icon.svg');
}

function ndi_schema_page() {
    ?>
    <div class="wrap">
        <h1>NDI Schema Settings</h1>
        <form method="post" action="options.php">
            <?php
            settings_fields('ndi_schema_settings');
            do_settings_sections('ndi-schema');
            submit_button();
            ?>
        </form>
    </div>
    <?php
}

add_action('admin_init', 'ndi_schema_settings');

function ndi_schema_settings() {
    register_setting('ndi_schema_settings', 'ndi_schema_common_code');
    
    add_settings_section('ndi_schema_main_section', 'Common Schema Code', null, 'ndi-schema');
    
    add_settings_field('ndi_schema_common_code', 'Common Schema Code', 'ndi_schema_common_code_callback', 'ndi-schema', 'ndi_schema_main_section');
}

function ndi_schema_common_code_callback() {
       echo do_shortcode('[ndi_logo]'); 
       echo '<div class="titletrack">SCHEMA</div>';
       echo '<div class="stytitl">Improve Performance</div>';
       echo '<p>NDI Schema plugin lets you add common and individual schema code to the head section of every WordPress page and post for improved SEO.</p>';
    $common_code = get_option('ndi_schema_common_code', '');
    echo '<textarea name="ndi_schema_common_code" rows="10" cols="50" class="large-text">' . esc_textarea($common_code) . '</textarea>';
}

// Add custom field to posts and pages
add_action('add_meta_boxes', 'ndi_schema_meta_box');

function ndi_schema_meta_box() {
    add_meta_box('ndi_schema_meta', 'Schema Code', 'ndi_schema_meta_callback', ['post', 'page'], 'normal', 'high');
}

function ndi_schema_meta_callback($post) {
    
     echo '<div class="custom-meta-box">';
    echo '<div class="plugintitle">NOBLE DYNASTY INFO - SCHEMA</div>';
    
    $schema_code = get_post_meta($post->ID, '_ndi_schema_code', true);
    echo '<textarea name="ndi_schema_code" rows="5" cols="100" style="width:100%;">' . esc_textarea($schema_code) . '</textarea>';
    echo '</div>';
}

add_action('save_post', 'ndi_schema_save_meta');

function ndi_schema_save_meta($post_id) {
    if (array_key_exists('ndi_schema_code', $_POST)) {
        update_post_meta($post_id, '_ndi_schema_code', $_POST['ndi_schema_code']);
    }
}

// Inject schema code into head
add_action('wp_head', 'ndi_schema_inject_code');

function ndi_schema_inject_code() {
    if (is_singular()) {
        global $post;
        $schema_code = get_post_meta($post->ID, '_ndi_schema_code', true);
        if ($schema_code) {
            echo $schema_code;
        }
    }
    
    $common_code = get_option('ndi_schema_common_code', '');
    if ($common_code) {
        echo $common_code;
    }
}
?>